<?php
// ═══════════════════════════════════════════════
//  TELEGRAM API CORE
// ═══════════════════════════════════════════════

function telegramRequest($method, $data) {
    $url = "https://api.telegram.org/bot" . BOT_TOKEN . "/$method";
    $ch  = curl_init($url);
    curl_setopt_array($ch, [
        CURLOPT_POST           => true,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_TIMEOUT        => 15,
        CURLOPT_POSTFIELDS     => json_encode($data),
        CURLOPT_HTTPHEADER     => ["Content-Type: application/json"],
    ]);
    $res = curl_exec($ch);
    $err = curl_error($ch);
    curl_close($ch);
    if ($err) error_log("[TheDark Bot] Telegram $method error: $err");
    return $res;
}

// ═══════════════════════════════════════════════
//  SEND MESSAGE  (plain text, no markdown issues)
// ═══════════════════════════════════════════════

function sendMessage($chat_id, $text, $keyboard = null) {
    $data = [
        "chat_id"    => $chat_id,
        "text"       => $text,
        "parse_mode" => "HTML"
    ];
    if ($keyboard) {
        $data["reply_markup"] = $keyboard;
    }
    return telegramRequest("sendMessage", $data);
}

// ═══════════════════════════════════════════════
//  SEND ANIMATION / GIF
// ═══════════════════════════════════════════════

function sendAnimation($chat_id) {
    $data = [
        "chat_id"    => $chat_id,
        "animation"  => "https://media.giphy.com/media/xT0xeJpnrWC4XWblEk/giphy.gif",
        "caption"    => "🎉 <b>Payment Confirmed!</b>",
        "parse_mode" => "HTML"
    ];
    telegramRequest("sendAnimation", $data);
}

// ═══════════════════════════════════════════════
//  ANSWER CALLBACK QUERY (removes spinner)
// ═══════════════════════════════════════════════

function answerCallback($callback_id, $text = "") {
    telegramRequest("answerCallbackQuery", [
        "callback_query_id" => $callback_id,
        "text"              => $text
    ]);
}

// ═══════════════════════════════════════════════
//  CREATE ONE-TIME CHANNEL INVITE LINK
// ═══════════════════════════════════════════════

function createInvite() {
    $res  = telegramRequest("createChatInviteLink", [
        "chat_id"      => CHANNEL_ID,
        "member_limit" => 1,
        "expire_date"  => time() + (30 * 24 * 60 * 60)
    ]);
    $json = json_decode($res, true);
    if (!empty($json['result']['invite_link'])) {
        return $json['result']['invite_link'];
    }
    error_log("[TheDark Bot] createInvite failed: $res");
    return null;
}
?>
