<?php
include "config.php";
include "functions.php";

$user  = $_GET['user']  ?? '';
$order = $_GET['order'] ?? '';

if (empty($user) || empty($order)) {
    error_log("[TheDark Bot] create_payment.php called with missing params");
    exit("Missing params");
}

// ── Build + sign SZ Secure request ───────────────────────────────
$params = [
    'api_key'           => API_KEY,
    'merchant_order_id' => $order,
    'amount'            => "2500",
    'notify_url'        => "https://membership.thedark.pro/callback.php"
];

ksort($params);
$raw = '';
foreach ($params as $k => $v) {
    $raw .= $k . '=' . $v . '&';
}
$raw .= 'key=' . API_SECRET;
$params['sign'] = md5($raw);

// ── Call SZ Secure API ────────────────────────────────────────────
$ch = curl_init("https://szsecure.pro/api/payment_create.php");
curl_setopt_array($ch, [
    CURLOPT_POST           => true,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_TIMEOUT        => 20,
    CURLOPT_POSTFIELDS     => json_encode($params),
    CURLOPT_HTTPHEADER     => ["Content-Type: application/json"],
]);
$response = curl_exec($ch);
$curl_err  = curl_error($ch);
curl_close($ch);

if ($curl_err) {
    error_log("[TheDark Bot] SZ Secure curl error: $curl_err");
    sendMessage($user, "❌ <b>Payment gateway error.</b>\n\nPlease try again or contact support.");
    exit;
}

$res = json_decode($response, true);

// ── Success ───────────────────────────────────────────────────────
if (!empty($res['status']) && $res['status'] == 1 && !empty($res['pay_url'])) {

    $pay_url = $res['pay_url'];

    $keyboard = [
        "inline_keyboard" => [[
            ["text" => "💳 Pay Now ₹2500", "url" => $pay_url]
        ]]
    ];

    sendMessage($user,
        "✅ <b>Payment Link Ready!</b>\n\n" .
        "Click the button below to complete your payment.\n\n" .
        "⚠️ Link is valid for a limited time only.",
        $keyboard
    );

// ── Failure ───────────────────────────────────────────────────────
} else {
    $err_msg = $res['message'] ?? 'Unknown error';
    error_log("[TheDark Bot] Payment creation failed | order: $order | error: $err_msg | raw: $response");

    sendMessage($user,
        "❌ <b>Could not generate payment link.</b>\n\n" .
        "Please try again using /start or contact support."
    );
}
?>
